<?php
// Arquivo: eliminar_aluno.php
// Objetivo: Receber o ID do aluno sem matrícula e deletá-lo do banco de dados.

// ----------------------
// 1. Conexão com o Banco de Dados (Use suas credenciais exatas)
// ----------------------
$host = "localhost";
$user = "root";
$pass = "";
$db = "sismag";
$port = 3307; // ajuste se necessário

$conn = new mysqli($host, $user, $pass, $db, $port);
if ($conn->connect_error) {
    die("Erro de conexão com o banco de dados.");
}

// ----------------------
// 2. Processamento da Exclusão
// ----------------------

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $aluno_id = (int)$_GET['id'];
    
    // USANDO PREPARED STATEMENTS para segurança contra SQL Injection
    
    // PASSO A: VERIFICAÇÃO FINAL DE SEGURANÇA:
    // Garante que o aluno realmente NÃO possui vínculos na tabela 'matriculas'.
    $sql_check = "SELECT COUNT(*) FROM matriculas WHERE aluno_id = ?";
    $stmt_check = $conn->prepare($sql_check);
    $stmt_check->bind_param("i", $aluno_id);
    $stmt_check->execute();
    $result_check = $stmt_check->get_result();
    $count = $result_check->fetch_row()[0];
    $stmt_check->close();
    
    if ($count == 0) {
        // PASSO B: EXCLUSÃO: Se não houver matrícula, deleta o registro.
        $sql_delete = "DELETE FROM alunos WHERE id = ?";
        $stmt_delete = $conn->prepare($sql_delete);
        $stmt_delete->bind_param("i", $aluno_id);
        
        if ($stmt_delete->execute()) {
            $status = "success_delete";
        } else {
            $status = "error_delete";
        }
        $stmt_delete->close();
        
    } else {
        // Aluno tem vínculo (alerta e cancela a operação)
        $status = "error_vinculo";
    }
} else {
    // ID inválido ou não fornecido
    $status = "error_invalid_id";
}

$conn->close();

// ----------------------
// 3. Redirecionamento e Mensagem
// ----------------------
// Redireciona de volta para a página de estatísticas com o status da operação.
// Você precisa saber o nome exato da sua página de estatísticas (ex: estatisticas.php)
$pagina_estatisticas = "sua_pagina_de_estatisticas.php"; // <--- ATUALIZE ESTE NOME

header("Location: " . $pagina_estatisticas . "?status=" . $status);
exit();
?>